/*:
 * @target MZ
 * @plugindesc 武器・防具をアイテムメニューから使用可能にし、コモンイベントを即時呼び出す
 * @author Grok
 * @help
 * ■使い方
 * 武器/防具のメモ欄に <CommonEvent: 5> のように記述すると、
 * そのIDのコモンイベントが**武器を選択した瞬間に**実行されます。
 *
 * メモ欄に何も書かなかった場合はグレーアウト（使用不可）になります。
 * 武器・防具は「武器」「防具」タブにのみ表示されます。
 *
 * ■注意
 * コモンイベント内でメッセージ表示や音などを入れると、
 * アイテムメニューが開いたまま実行されるようになります。
 * メニューを閉じたい場合は、コモンイベントの最後に
 * SceneManager.pop(); を入れてください。
 * 立ち絵の更新が必要な場合は、コモンイベント内に
 * $gameParty.menuActor().refresh();
 * SceneManager._scene._statusWindow.refresh();
 * を追加してください。
 */

(function() {

    // アイテムリストに含めるかを判定（カテゴリを尊重する） → 変更なし
    const _Window_ItemList_includes = Window_ItemList.prototype.includes;
    Window_ItemList.prototype.includes = function(item) {
        if (DataManager.isItem(item)) {
            return _Window_ItemList_includes.call(this, item);
        }
        if (DataManager.isWeapon(item) || DataManager.isArmor(item)) {
            if (this._category === "weapon" || this._category === "armor") {
                return true;
            }
            return false;
        }
        return _Window_ItemList_includes.call(this, item);
    };

    // 使用可能にする → 変更なし
    const _Window_ItemList_isEnabled = Window_ItemList.prototype.isEnabled;
    Window_ItemList.prototype.isEnabled = function(item) {
        if (DataManager.isWeapon(item) || DataManager.isArmor(item)) {
            return !!item.meta.CommonEvent;
        }
        return _Window_ItemList_isEnabled.call(this, item);
    };

    // 使用時の処理（即時実行版に修正）
    const _Scene_ItemBase_useItem = Scene_ItemBase.prototype.useItem;
    Scene_ItemBase.prototype.useItem = function() {
        const item = this.item();
        if (DataManager.isWeapon(item) || DataManager.isArmor(item)) {
            const commonEventId = Number(item.meta.CommonEvent || 0);
            if (commonEventId > 0) {
                SoundManager.playUseItem();

                // ★★★ 即時実行: 専用のインタープリタを作成して実行 ★★★
                const event = $dataCommonEvents[commonEventId];
                if (event) {
                    const interpreter = new Game_Interpreter();
                    interpreter.setup(event.list, 0);
                    interpreter.update();  // 実行開始（ループで処理される）
                }

                // ウィンドウを再活性化（メニューがフリーズしないように）
                this.activateItemWindow();

                return;
            } else {
                SoundManager.playBuzzer();
                this.activateItemWindow();
                return;
            }
        }
        _Scene_ItemBase_useItem.call(this);
    };

})();